<?php
/**
 * View: Award icon.
 *
 * @since 4.6.0
 * @version 4.6.0
 *
 * @var array<int, string>|null $classes     List of classes to add to the icon.
 * @var bool|null               $aria_hidden Whether to hide the icon from screen readers.
 * @var Template                $this        The template instance.
 *
 * @package LearnDash\Core
 */

/** NOTICE: This code is currently under development and may not be stable.
 *  Its functionality, behavior, and interfaces may change at any time without notice.
 *  Please refrain from using it in production or other critical systems.
 *  By using this code, you assume all risks and liabilities associated with its use.
 *  Thank you for your understanding and cooperation.
 **/

use LearnDash\Core\Template\Template;

$icon_classes = [ 'ld-icon', 'ld-icon--award' ];

if ( ! empty( $classes ) ) {
	$icon_classes = array_merge( $icon_classes, $classes );
}

$aria_hidden = $aria_hidden ?? true;
?>
<?php $this->template( 'components/icons/icon/start', compact( 'icon_classes', 'aria_hidden' ) ); ?>
<path d="M10.3908 3.99548C10.2534 3.99364 10.0879 4.01544 9.87688 4.07189C8.75152 4.37349 9.23954 4.88425 8.23062 5.46683C7.22156 6.04927 7.02358 5.37124 6.19966 6.19502C5.37588 7.01894 6.05392 7.21692 5.47147 8.22598C4.88889 9.2349 4.37814 8.74684 4.07654 9.87223C3.77507 10.9976 4.4615 10.8302 4.4615 11.9954C4.4615 13.1605 3.77506 12.9931 4.07654 14.1185C4.37813 15.2438 4.88889 14.7558 5.47147 15.7647C6.05391 16.7738 5.37588 16.9718 6.19966 17.7957C7.02358 18.6195 7.22156 17.9414 8.23062 18.5239C9.23954 19.1065 8.75148 19.6172 9.87688 19.9188C11.0022 20.2203 10.8348 19.5339 12 19.5339C13.1652 19.5339 12.9978 20.2203 14.1231 19.9188C15.2485 19.6172 14.7605 19.1065 15.7694 18.5239C16.7784 17.9414 16.9764 18.6195 17.8003 17.7957C18.6241 16.9718 17.9461 16.7738 18.5285 15.7647C19.1111 14.7558 19.6219 15.2439 19.9235 14.1185C20.2249 12.9931 19.5385 13.1605 19.5385 11.9954C19.5385 10.8302 20.2249 10.9976 19.9235 9.87223C19.6219 8.74688 19.1111 9.2349 18.5285 8.22598C17.9461 7.21692 18.6241 7.01894 17.8003 6.19502C16.9764 5.37123 16.7784 6.04928 15.7694 5.46683C14.7605 4.88425 15.2485 4.3735 14.1231 4.07189C12.9978 3.77043 13.1652 4.45686 12 4.45686C11.0533 4.45686 10.9864 4.00365 10.3908 3.99548ZM12 5.62597C15.5146 5.62597 18.3693 8.48071 18.3693 11.9953C18.3693 15.5098 15.5146 18.3646 12 18.3646C8.48544 18.3646 5.63069 15.5098 5.63069 11.9953C5.63069 8.48071 8.48544 5.62597 12 5.62597ZM12 6.13225C8.75898 6.13225 6.1369 8.75432 6.1369 11.9953C6.1369 15.2364 8.75898 17.8584 12 17.8584C15.241 17.8584 17.8631 15.2364 17.8631 11.9953C17.8631 8.75432 15.241 6.13225 12 6.13225ZM12 7.70274C12.6568 7.70274 12.9947 9.58836 13.5261 9.97437C14.0575 10.3605 15.955 10.099 16.158 10.7237C16.361 11.3483 14.6724 12.2527 14.4695 12.8773C14.2665 13.5019 15.1012 15.2257 14.5698 15.6119C14.0384 15.9979 12.6568 14.6714 12 14.6714C11.3433 14.6714 9.96156 15.9979 9.43021 15.6119C8.89882 15.2257 9.73351 13.5019 9.53052 12.8773C9.32766 12.2527 7.63902 11.3483 7.84201 10.7237C8.045 10.099 9.94255 10.3605 10.4739 9.97437C11.0053 9.58836 11.3432 7.70274 12 7.70274Z" fill="currentColor"/>
<?php $this->template( 'components/icons/icon/end' ); ?>
