<?php
/**
 * View: Mastercard logo small.
 *
 * @since 4.25.0
 * @version 4.25.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__mastercard-small' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Mastercard logo', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 17,
		'label'   => $label,
		'width'   => 26,
	],
);

?>

<g clip-path="url(#clip0_16085_26107)">
	<path d="M0 1.41748C0 0.708146 0.5798 0.132812 1.2948 0.132812H24.7052C25.4202 0.132812 26 0.708146 26 1.41748V14.8481C26 15.5575 25.4202 16.1328 24.7052 16.1328H1.2948C0.5798 16.1328 0 15.5575 0 14.8481V1.41748Z" fill="white"/>
	<path d="M7.20764 14.933V14.0264C7.20764 13.6784 7.00094 13.451 6.64604 13.451C6.46924 13.451 6.27684 13.511 6.14359 13.7084C6.03959 13.5417 5.89269 13.451 5.67104 13.451C5.52284 13.451 5.37529 13.4964 5.25699 13.663V13.4817H4.94629V14.933H5.25699V14.1317C5.25699 13.8744 5.38959 13.7537 5.59694 13.7537C5.80364 13.7537 5.90764 13.8904 5.90764 14.1324V14.933H6.21769V14.1317C6.21769 13.8744 6.36719 13.7537 6.55829 13.7537C6.76629 13.7537 6.86899 13.8904 6.86899 14.1324V14.933H7.20894H7.20764ZM11.8064 13.4817H11.3033V13.043H10.9926V13.4817H10.7118V13.7684H10.9926V14.4337C10.9926 14.767 11.1258 14.9637 11.4801 14.9637C11.614 14.9637 11.7615 14.9184 11.8649 14.857L11.7765 14.5857C11.6881 14.6457 11.5841 14.6617 11.51 14.6617C11.3624 14.6617 11.3033 14.5704 11.3033 14.4197V13.769H11.8064V13.4817ZM14.4376 13.451C14.2601 13.451 14.1425 13.5417 14.0684 13.663V13.4817H13.7577V14.933H14.0684V14.1164C14.0684 13.8744 14.1724 13.7384 14.3641 13.7384C14.4226 13.7384 14.4967 13.7537 14.5559 13.769L14.6449 13.4664C14.5864 13.451 14.4974 13.451 14.4376 13.451ZM10.4609 13.6024C10.3127 13.4957 10.106 13.451 9.88369 13.451C9.52879 13.451 9.29219 13.6324 9.29219 13.9197C9.29219 14.1617 9.47029 14.2977 9.77969 14.343L9.92919 14.3584C10.0917 14.3884 10.1794 14.4337 10.1794 14.5097C10.1794 14.6164 10.0611 14.691 9.85444 14.691C9.64644 14.691 9.48394 14.6157 9.38124 14.5397L9.23304 14.7817C9.39554 14.9017 9.61654 14.963 9.83884 14.963C10.2529 14.963 10.4888 14.7664 10.4888 14.4944C10.4888 14.2377 10.2971 14.101 10.0013 14.0557L9.85379 14.041C9.72054 14.0257 9.61719 13.9957 9.61719 13.905C9.61719 13.7984 9.72119 13.7384 9.88369 13.7384C10.0605 13.7384 10.2379 13.8144 10.327 13.8597L10.4609 13.6024ZM18.7107 13.451C18.5332 13.451 18.4149 13.5417 18.3415 13.663V13.4817H18.0308V14.933H18.3415V14.1164C18.3415 13.8744 18.4455 13.7384 18.6372 13.7384C18.6957 13.7384 18.7692 13.7537 18.8283 13.769L18.9174 13.4664C18.8589 13.451 18.7698 13.451 18.7107 13.451ZM14.7483 14.207C14.7483 14.647 15.044 14.9637 15.5023 14.9637C15.7103 14.9637 15.8572 14.9184 16.0054 14.797L15.8572 14.5404C15.7389 14.631 15.6206 14.6764 15.4867 14.6764C15.2364 14.6764 15.059 14.495 15.059 14.2077C15.059 13.9364 15.2364 13.7544 15.488 13.7397C15.6206 13.7397 15.7389 13.785 15.8572 13.8757L16.0054 13.619C15.8572 13.4977 15.7096 13.4524 15.5023 13.4524C15.044 13.4524 14.7483 13.7704 14.7483 14.2084V14.207ZM17.6167 14.207V13.4824H17.3047V13.6637C17.202 13.5277 17.0545 13.4517 16.8627 13.4517C16.463 13.4517 16.1523 13.7697 16.1523 14.2077C16.1523 14.6477 16.463 14.9644 16.8621 14.9644C17.0681 14.9644 17.2163 14.889 17.3041 14.753V14.9344H17.6161V14.2077L17.6167 14.207ZM16.4773 14.207C16.4773 13.951 16.6398 13.739 16.9063 13.739C17.1578 13.739 17.3353 13.9357 17.3353 14.2077C17.3353 14.4657 17.1578 14.677 16.9063 14.677C16.6398 14.6624 16.4773 14.4657 16.4773 14.2084V14.207ZM12.7658 13.4517C12.3524 13.4517 12.0573 13.7544 12.0573 14.2077C12.0573 14.6624 12.3524 14.9644 12.7814 14.9644C12.9894 14.9644 13.1961 14.9044 13.3586 14.7677L13.2104 14.541C13.0934 14.6317 12.9439 14.6924 12.797 14.6924C12.6046 14.6924 12.4122 14.6017 12.368 14.3444H13.4177V14.2244C13.432 13.755 13.1655 13.4524 12.7664 13.4524L12.7658 13.4517ZM12.7658 13.725C12.9588 13.725 13.0921 13.845 13.1213 14.0717H12.3823C12.4115 13.875 12.5448 13.725 12.7658 13.725ZM20.4696 14.2077V12.9077H20.1576V13.6644C20.0549 13.5284 19.9073 13.4524 19.7156 13.4524C19.3158 13.4524 19.0051 13.7704 19.0051 14.2084C19.0051 14.6484 19.3158 14.965 19.7149 14.965C19.9216 14.965 20.0692 14.8897 20.1569 14.7537V14.935H20.4689V14.2084L20.4696 14.2077ZM19.3308 14.2077C19.3308 13.9517 19.4933 13.7397 19.7598 13.7397C20.0107 13.7397 20.1888 13.9364 20.1888 14.2084C20.1888 14.4664 20.0107 14.6777 19.7598 14.6777C19.4933 14.663 19.3308 14.4664 19.3308 14.209V14.2077ZM8.95029 14.2077V13.483H8.64089V13.6644C8.53689 13.5284 8.38934 13.4524 8.19694 13.4524C7.79719 13.4524 7.48649 13.7704 7.48649 14.2084C7.48649 14.6484 7.79719 14.965 8.19629 14.965C8.40299 14.965 8.55054 14.8897 8.63959 14.7537V14.935H8.94964V14.2084L8.95029 14.2077ZM7.79784 14.2077C7.79784 13.9517 7.96034 13.7397 8.22684 13.7397C8.47774 13.7397 8.65584 13.9364 8.65584 14.2084C8.65584 14.4664 8.47774 14.6777 8.22684 14.6777C7.96034 14.663 7.79784 14.4664 7.79784 14.209V14.2077Z" fill="black"/>
	<path d="M15.0117 2.45947H10.3545V11.0168H15.0117" fill="#FF5F00"/>
	<path d="M10.6473 6.74021C10.6473 5.00021 11.4468 3.45888 12.6734 2.46021C11.7699 1.73554 10.6324 1.29688 9.39088 1.29688C6.44768 1.29688 4.06738 3.73021 4.06738 6.73954C4.06738 9.74621 6.44768 12.1809 9.39088 12.1809C10.6324 12.1809 11.7699 11.7429 12.6734 11.0169C11.4449 10.0342 10.6467 8.47688 10.6467 6.73888L10.6473 6.74021Z" fill="#EB001B"/>
	<path d="M21.2915 6.73941C21.2915 9.74608 18.9099 12.1807 15.968 12.1807C14.7265 12.1807 13.5877 11.7427 12.6855 11.0167C13.927 10.0194 14.7109 8.47674 14.7109 6.73874C14.7109 4.99874 13.9127 3.45741 12.6855 2.45874C13.5877 1.73408 14.7265 1.29541 15.968 1.29541C18.9099 1.29541 21.2915 3.74474 21.2915 6.73808V6.73941Z" fill="#F79E1B"/>
</g>
<defs>
	<clipPath id="clip0_16085_26107">
		<rect width="26" height="16" fill="white" transform="translate(0 0.132812)"/>
	</clipPath>
</defs>

<?php
$this->template( 'components/icons/icon/end' );
