<?php
/**
 * View: Bell Icon.
 *
 * @since 4.23.0
 * @version 4.23.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__bell' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Bell icon', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 11,
		'label'   => $label,
		'width'   => 10,
	],
);
?>

<path d="M5.85385 8.40582C6.05546 8.29014 6.31703 8.32833 6.47689 8.50934C6.65963 8.71637 6.63998 9.03266 6.43295 9.21539L6.28451 9.33453C5.92522 9.59941 5.48075 9.75634 5.00033 9.75641C4.5197 9.75641 4.07459 9.59955 3.71518 9.33453L3.56674 9.21539L3.4974 9.1402C3.35783 8.95451 3.36307 8.69033 3.52279 8.50934C3.68258 8.3283 3.94422 8.29027 4.14584 8.40582L4.22885 8.46539L4.30893 8.52985C4.50248 8.67255 4.74122 8.75641 5.00033 8.75641C5.29642 8.75632 5.56593 8.64711 5.77182 8.46539L5.85385 8.40582ZM7.00033 3.4234C7.00033 2.89305 6.78936 2.38439 6.41439 2.00934C6.08619 1.68113 5.65547 1.47861 5.1976 1.43317L5.00033 1.4234C4.4699 1.4234 3.96037 1.63427 3.58529 2.00934C3.21042 2.38438 3.00033 2.89312 3.00033 3.4234L2.99643 3.67633C2.96198 4.75416 2.70884 5.57029 2.389 6.17535L2.23666 6.44C2.18356 6.52534 2.1367 6.60257 2.09408 6.67145C2.14109 6.6715 2.19154 6.6734 2.24545 6.6734H7.75424C7.80766 6.6734 7.85798 6.6715 7.90463 6.67145L7.76303 6.44C7.34848 5.77379 7.00033 4.79973 7.00033 3.4234ZM8.00033 3.4234C8.00033 4.62222 8.30152 5.41168 8.61264 5.91168L8.9642 6.48785C9.00433 6.55748 9.04213 6.62721 9.07064 6.69C9.08485 6.7213 9.10143 6.76107 9.11459 6.80524C9.12269 6.83245 9.13776 6.88491 9.14096 6.95172L9.139 7.02301C9.13402 7.08382 9.12134 7.19509 9.05697 7.3111C9.0247 7.36919 8.98671 7.41616 8.95053 7.4527L8.8558 7.53375C8.73143 7.62601 8.58991 7.64534 8.55209 7.65094C8.48631 7.66068 8.4132 7.66477 8.34213 7.66754C8.19842 7.67314 7.99874 7.6734 7.75424 7.6734H2.24545C2.00112 7.6734 1.80222 7.67313 1.65853 7.66754C1.58731 7.66477 1.51352 7.66071 1.4476 7.65094C1.41901 7.64671 1.33248 7.63492 1.23861 7.59039L1.14486 7.53375C1.09586 7.49741 1.0073 7.42735 0.942714 7.3111C0.910486 7.25298 0.891107 7.19606 0.879238 7.14606L0.860683 7.02301C0.852505 6.92302 0.874286 6.84154 0.885097 6.80524C0.89824 6.76111 0.914851 6.72128 0.929043 6.69C0.957557 6.62721 0.995359 6.55748 1.03549 6.48785C1.11658 6.34716 1.2372 6.15408 1.38803 5.91168L1.50326 5.71051C1.73137 5.27985 1.93361 4.67798 1.98666 3.85406L2.00033 3.4234C2.00033 2.6279 2.31585 1.86489 2.87826 1.30231C3.44087 0.739698 4.20468 0.423401 5.00033 0.423401L5.29623 0.438049C5.9831 0.506185 6.62908 0.809958 7.12143 1.30231C7.68393 1.8649 8.00033 2.62783 8.00033 3.4234Z" fill="currentColor"/>

<?php
$this->template( 'components/icons/icon/end' );
