<?php
/**
 * Plugin Name: LearnDash Smart Engine
 * Plugin URI: https://kamangir.co
 * Description: Smart customizations and enhancements for LearnDash LMS
 * Version: 1.2.0
 * Author: Arash Kamangir Group
 * Author URI: https://kamangir.co
 * Text Domain: ld-smart-engine
 * Domain Path: /languages
 * Requires at least: 5.0
 * Tested up to: 6.8
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Network: false
 * 
 * @package LearnDash_Smart_Engine
 * @since 1.0.0
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants
define( 'LD_SMART_ENGINE_VERSION', '1.0.0' );
define( 'LD_SMART_ENGINE_BASENAME', plugin_basename( __FILE__ ) );
define( 'LD_SMART_ENGINE_PATH', plugin_dir_path( __FILE__ ) );
define( 'LD_SMART_ENGINE_URL', plugin_dir_url( __FILE__ ) );
define( 'LD_SMART_ENGINE_TEXT_DOMAIN', 'ld-smart-engine' );

// Load main plugin class
require_once LD_SMART_ENGINE_PATH . 'includes/class-main-plugin.php';

// Initialize plugin
LearnDash_Smart_Engine_Main::get_instance();

/**
 * @author kamangir
 */
require_once plugin_dir_path( __FILE__ ) . "kamangir/kamangir.php";