<?php

add_shortcode( 'ld_courses_count', function () {
    if ( ! is_user_logged_in() ) {
        return 'لطفاً ابتدا وارد شوید.';
    }

    $user_id = get_current_user_id();
    $courses = ld_get_mycourses( $user_id );
    $count = is_array( $courses ) ? count( $courses ) : 0;

    return $count;
} );

add_shortcode( 'ld_completed_courses_count', function () {
    if ( ! is_user_logged_in() ) {
        return 'لطفاً ابتدا وارد شوید.';
    }

    $user_id = get_current_user_id();
    $courses = ld_get_mycourses( $user_id );

    if ( empty( $courses ) || ! is_array( $courses ) ) {
        return '0';
    }

    $completed_courses_count = 0;

    foreach ( $courses as $course_id ) {
        if ( learndash_course_completed( $user_id, $course_id ) ) {
            $completed_courses_count++;
        }
    }

    return $completed_courses_count;
} );


add_filter('get_avatar', function($avatar, $id_or_email, $size, $default, $alt) {
 if (is_numeric($id_or_email)) {
  $user_id = $id_or_email;
 } else {
  $user = get_user_by('email', $id_or_email);
  $user_id = $user ? $user->ID : null;
 }

 if ($user_id) {
  $custom_avatar_url = get_user_meta($user_id, 'custom_default_avatar_url', true);

  if ($custom_avatar_url) {
   return '<img alt="' . esc_attr($alt) . '" src="' . esc_url($custom_avatar_url) . '" class="avatar avatar-' . $size . ' photo" height="' . $size . '" width="' . $size . '">';
  }
 }

 return $avatar;
}, 10, 5);




function total_user_purchases_number_only_shortcode() {
    if ( ! is_user_logged_in() ) {
        return '';
    }

    $user_id = get_current_user_id();

    $customer_orders = wc_get_orders( array(
        'customer_id' => $user_id,
        'status'      => array( 'completed', 'processing' ),
        'return'      => 'ids',
        'limit'       => -1
    ) );

    $total_spent = 0;

    foreach ( $customer_orders as $order_id ) {
        $order = wc_get_order( $order_id );
        $total_spent += $order->get_total();
    }

    return number_format( $total_spent );
}
add_shortcode( 'user_total_purchase', 'total_user_purchases_number_only_shortcode' );



